﻿var TaxiApp = angular.module('DriverCities', ['ngStorage', 'ngDialog', 'angularUtils.directives.dirPagination', 'ui.bootstrap']);
var company, TariffList;


TaxiApp.controller('DriverCitiesCtrl', ['$scope', '$http', '$sessionStorage', 'ngDialog',
    function ($scope, $http, $sessionStorage, ngDialog, $confirm) {
        $scope.Role = sessionStorage.RoleType;
        $scope.RoleID = sessionStorage.RoleID;
        $scope.DisplayName = sessionStorage.UserName;
        $scope.CompanyName = sessionStorage.value;
        if (sessionStorage.OrderId < 0) {
            window.location.href = "../../Access.html";
        }
        else {
            Localization(sessionStorage.selectedLanguage, 'user', $scope, sessionStorage);
            $scope.loading = true;
            // $('.driveradd').hide();

            if (sessionStorage.length == (undefined || 0)) {
                window.parent.location.href = "../../Index.html";
            }
            else {
                var TokenID = sessionStorage.TokenID;
                var orgOID = sessionStorage.ORGOID;
                var userOID = sessionStorage.UserOID;
                var roleType = sessionStorage.RoleType;
                var roleID = sessionStorage.RoleID;
                var companyOID = sessionStorage.CompanyOID;

                $scope.Role = sessionStorage.RoleType;



                if (sessionStorage.CompanyOID != undefined || sessionStorage.ORGOID != undefined) {
                    loadDropDownFromAppConfig("COMPANY", sessionStorage.UserOID, sessionStorage.CompanyOID, sessionStorage.ORGOID, 0, $scope);
                }

                loadContents(sessionStorage.ORGOID, sessionStorage.CompanyOID, sessionStorage.UserOID, 'DT', $scope);

                $scope.currentPage = 1

                $scope.Governorates = {
                    add: function () {
                        $('#AddGovernorate').modal('toggle');

                    },
                    save: function () {
                        var governorate = {
                            "Name": $scope.e_GovernorateName,
                           
                            "ModifiedBy": sessionStorage.UserOID,
                            "TokenID": sessionStorage.TokenID

                        }
                        var obj = {};

                        obj["obj"] = governorate;
                        $.ajax({
                            type: "POST",
                            url: ManagementServiceUrl + "AddGovernorate",
                            data: JSON.stringify(obj),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            processData: true,
                            success: function (data) {
                                if (data.AddGovernorateResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                var res = JSON.parse(data.AddGovernorateResult);
                                // var str = "Hello world, welcome to the universe.";

                                //  console.log(res)
                                if (res = 'success') {
                                    $('#AddGovernorate').modal('toggle');
                                    $scope.Governorates.get()

                                } else {
                                    alert(res + "حدث خطأ  ")

                                }
                            }
                        });
                    },
                    get: function () {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetGovernorates/" + userOID +"/"+sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetGovernoratesResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.GovernoratesList = JSON.parse(result.GetGovernoratesResult);
                                //  console.log($scope.driverList)

                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });
                    },
               

                }
                $scope.Cities = {
                    remove: function (c) {
                        $scope.loading = true;
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "DeleteGovernorateCity/" + c.OID + "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.DeleteGovernorateCityResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Cities.get(c.Governorate);

                                if (result.DeleteGovernorateCityResult == "\"1\"") {
                                    $scope.Governorates.get();


                                }
                                //  console.log($scope.driverList)


                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });


                    },
                    add: function () {
                        if ($scope.Governorate == 'undefined' || $scope.Governorate == null || $scope.Governorate.length == 0) {
                            alert('يرجى اختيار المحافظة');
                            return;
                        }
                        $('#AddCity').modal('toggle');

                    },
                    save: function () {
                        if ($scope.Governorate == 'undefined' || $scope.Governorate == null || $scope.Governorate.length == 0) {
                            alert('يرجى اختيار المحافظة');
                            return;
                        }

                        var city = {
                            "Name": $scope.e_CityName,
                            "Governorate": $scope.Governorate,

                            "ModifiedBy": sessionStorage.UserOID,
                            "TokenID": sessionStorage.TokenID

                        }
                        var obj = {};

                        obj["obj"] = city;
                        $.ajax({
                            type: "POST",
                            url: ManagementServiceUrl + "AddGovernorateCity",
                            data: JSON.stringify(obj),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            processData: true,
                            success: function (data) {
                                if (data.AddGovernorateCityResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                var res = JSON.parse(data.AddGovernorateCityResult);
                                // var str = "Hello world, welcome to the universe.";

                                //  console.log(res)
                                if (res = 'success') {
                                    $('#AddCity').modal('toggle');
                                    $scope.Cities.get($scope.Governorate)

                                } else {
                                    alert(res + "حدث خطأ  ")

                                }
                            }
                        });
                    },
                    get: function (Governorate) {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetGovernorateCities/" +Governorate+"/"+ userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetGovernorateCitiesResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.CitiesList = JSON.parse(result.GetGovernorateCitiesResult);
                                //  console.log($scope.driverList)

                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });
                    },


                }

                $scope.Governorates.get()

                $scope.SelectGovernorate = function (Governorate) {
                    $scope.Cities.get(Governorate)
                }

            }
        }
    }]);



