﻿var TaxiApp = angular.module('CarMakes', ['ngStorage', 'ngDialog', 'angularUtils.directives.dirPagination', 'ui.bootstrap']);
var company, TariffList;


TaxiApp.controller('CarMakesCtrl', ['$scope', '$http', '$sessionStorage', 'ngDialog',
    function ($scope, $http, $sessionStorage, ngDialog, $confirm) {
        $scope.Role = sessionStorage.RoleType;
        $scope.RoleID = sessionStorage.RoleID;
        $scope.DisplayName = sessionStorage.UserName;
        $scope.CompanyName = sessionStorage.value;
        if (sessionStorage.OrderId < 0) {
          //  window.location.href = "../../Access.html";
        }
        else {
            Localization(sessionStorage.selectedLanguage, 'user', $scope, sessionStorage);
            $scope.loading = true;
            // $('.driveradd').hide();

            if (sessionStorage.length == (undefined || 0)) {
                window.parent.location.href = "../../Index.html";
            }
            else {
                var TokenID = sessionStorage.TokenID;
                var orgOID = sessionStorage.ORGOID;
                var userOID = sessionStorage.UserOID;
                var roleType = sessionStorage.RoleType;
                var roleID = sessionStorage.RoleID;
                var companyOID = sessionStorage.CompanyOID;

                $scope.Role = sessionStorage.RoleType;



                if (sessionStorage.CompanyOID != undefined || sessionStorage.ORGOID != undefined) {
                    loadDropDownFromAppConfig("COMPANY", sessionStorage.UserOID, sessionStorage.CompanyOID, sessionStorage.ORGOID, 0, $scope);
                }

                loadContents(sessionStorage.ORGOID, sessionStorage.CompanyOID, sessionStorage.UserOID, 'DT', $scope);

                $scope.currentPage = 1

                $scope.CarMakes = {
                    add: function () {
                        $('#AddMake').modal('toggle');

                    },
                    save: function () {
                        var make = {
                            "Name": $scope.e_MakeName,
                           
                            "ModifiedBy": sessionStorage.UserOID,
                            "TokenID": sessionStorage.TokenID

                        }
                        var obj = {};

                        obj["obj"] = make;
                        $.ajax({
                            type: "POST",
                            url: ManagementServiceUrl + "AddMake",
                            data: JSON.stringify(obj),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            processData: true,
                            success: function (data) {
                                if (data.AddMakeResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                var res = JSON.parse(data.AddMakeResult);
                                // var str = "Hello world, welcome to the universe.";

                                //  console.log(res)
                                if (res = 'success') {
                                    $('#AddMake').modal('toggle');
                                    $scope.CarMakes.get()

                                } else {
                                    alert(res + "حدث خطأ  ")

                                }
                            }
                        });
                    },
                    get: function () {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetMakes/" + userOID +"/"+sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetMakesResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Makes = JSON.parse(result.GetMakesResult);
                                //  console.log($scope.driverList)

                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });
                    },
               

                }
                $scope.CarModels = {
                    remove: function (city) {
                        $scope.loading = true;
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "DeleteCarModel/" + city.OID + "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.DeleteCarModelResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.CarModels.get(city.Make);

                                if (result.DeleteCarModelResult == "\"1\"") {
                                    $scope.CarMakes.get();
                                    

                                } 
                                //  console.log($scope.driverList)


                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });


                    },
                    add: function () {
                        if ($scope.Make == 'undefined' || $scope.Make == null || $scope.Make.length == 0) {
                            alert('يرجى اختيار الشركة المصنعة');
                            return;
                        }
                        $('#AddModel').modal('toggle');

                    },
                    save: function () {
                        if ($scope.Make == 'undefined' || $scope.Make == null || $scope.Make.length == 0) {
                            alert('يرجى اختيار الشركة المصنعة');
                            return;
                        }

                        var make = {
                            "Name": $scope.e_ModelName,
                            "Make": $scope.Make,

                            "ModifiedBy": sessionStorage.UserOID,
                            "TokenID": sessionStorage.TokenID

                        }
                        var obj = {};

                        obj["obj"] = make;
                        $.ajax({
                            type: "POST",
                            url: ManagementServiceUrl + "AddModel",
                            data: JSON.stringify(obj),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            processData: true,
                            success: function (data) {
                                if (data.AddModelResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                var res = JSON.parse(data.AddModelResult);
                                // var str = "Hello world, welcome to the universe.";

                                //  console.log(res)
                                if (res = 'success') {
                                    $('#AddModel').modal('toggle');
                                    $scope.CarModels.get($scope.Make)

                                } else {
                                    alert(res + "حدث خطأ  ")

                                }
                            }
                        });
                    },
                    get: function (make) {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetModels/" +make+"/"+ userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetModelsResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Models = JSON.parse(result.GetModelsResult);
                                //  console.log($scope.driverList)

                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });
                    },


                }

                $scope.CarMakes.get()

                $scope.SelectMake = function (make) {
                    $scope.CarModels.get(make)
                }

            }
        }
    }]);



