﻿var TaxiApp = angular.module('TariffList', ['ngStorage', 'ngDialog', 'angularUtils.directives.dirPagination', 'ui.bootstrap']);
var company, TariffList;

TaxiApp.controller('EditTariffCtrl', function ($scope, $http, $sessionStorage, ngDialog, $window, obj) {

    $scope.ClickClose = function () {
        $(".ngdialog-close").trigger("click");

    }
})

TaxiApp.controller('TariffCtrl', ['$scope', '$http', '$sessionStorage', 'ngDialog',
    function ($scope, $http, $sessionStorage, ngDialog, $confirm) {
        $scope.Role = sessionStorage.RoleType;
        $scope.RoleID = sessionStorage.RoleID;
        $scope.DisplayName = sessionStorage.UserName;
        $scope.CompanyName = sessionStorage.value;
        if (sessionStorage.OrderId < 2) {
            window.location.href = "../../Access.html";
        }
        else {
            Localization(sessionStorage.selectedLanguage, 'user', $scope, sessionStorage);
            $scope.loading = true;
            // $('.driveradd').hide();

            if (sessionStorage.length == (undefined || 0)) {
                window.parent.location.href = "../../Index.html";
            }
            else {
                var TokenID = sessionStorage.TokenID;
                var orgOID = sessionStorage.ORGOID;
                var userOID = sessionStorage.UserOID;
                var roleType = sessionStorage.RoleType;
                var roleID = sessionStorage.RoleID;
                var companyOID = sessionStorage.CompanyOID;

                $scope.Role = sessionStorage.RoleType;

                loadDropDownFromAppConfig("CARTYPE", userOID, companyOID, orgOID, 0, $scope);
                loadCurrencyTypes($scope);

                // console.log($scope.CARTYPE)

                loadDropDownFromAppConfig("Group", sessionStorage.UserOID, sessionStorage.CompanyOID, sessionStorage.ORGOID, 0, $scope);
                if (sessionStorage.CompanyOID != undefined || sessionStorage.ORGOID != undefined) {
                    loadDropDownFromAppConfig("COMPANY", sessionStorage.UserOID, sessionStorage.CompanyOID, sessionStorage.ORGOID, 0, $scope);
                }

                loadContents(sessionStorage.ORGOID, sessionStorage.CompanyOID, sessionStorage.UserOID, 'DT', $scope);
                $scope.SelectedDistrict = function (districtOid) {
                    //  console.log()

                    $scope.DistrictName = $.grep($scope.DistrictList, function (item) {
                        return item.OID == districtOid;
                    })[0].value;
                    console.log($scope.DistrictListModel)
                    $scope.loadDailyBooking();

                }

                $scope.currentPage = 1

                $scope.TariffList = {
                    get: function (cityid) {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetTariffList/" + userOID + "/" +cityid +"/"+sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetCompanyDriversResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.tariffList = JSON.parse(result.GetTariffListResult);
                                //  console.log($scope.driverList)

                                $scope.loading = false; $scope.$apply();
                            }
                        });
                    },
                    add: function () {
                        $('#AddModal').modal('toggle');
                    },
                    
                    saveNew: function() {
                        if ($scope.e_Name == undefined || $scope.e_Name == "" ||
                            $scope.e_ServiceType == undefined || $scope.e_ServiceType == "" ||
                            $scope.e_City == undefined || $scope.e_City == "" ||
                            $scope.e_Currency == undefined || $scope.e_Currency == "" ||
                            $scope.e_MinCharge_Day == undefined || $scope.e_MinCharge_Day == null ||
                            $scope.e_MinCharge_Night == undefined || $scope.e_MinCharge_Night == null ||
                            $scope.e_DistanceCharge_Day == undefined || $scope.e_DistanceCharge_Day == null ||
                            $scope.e_DistanceCharge_Night == undefined || $scope.e_DistanceCharge_Night == null ||
                            $scope.e_WaitingCharge_Day == undefined || $scope.e_WaitingCharge_Day == null ||
                            $scope.e_WaitingCharge_Night == undefined || $scope.e_WaitingCharge_Night == null ||
                            $scope.e_StartCharge_Day == undefined || $scope.e_StartCharge_Day == null ||
                            $scope.e_StartCharge_Night == undefined || $scope.e_StartCharge_Night == null ||

                            $scope.e_Penalty_Distance == undefined || $scope.e_Penalty_Distance == null ||
                            $scope.e_Driver_Compensation == undefined || $scope.e_Driver_Compensation == null ||
                            $scope.e_User_Penelty == undefined || $scope.e_User_Penelty == null ||

                            $scope.e_Tax == undefined || $scope.e_Tax == null ||
                            $scope.e_Gov_Fees == undefined || $scope.e_Gov_Fees == null ||
                            $scope.e_App_Commission == undefined || $scope.e_App_Commission == null
                        ) {
                            alert("يرجى ادخال جميع الحقول")
                            return;
                        } 

                        var tariff = {
                            "TariffName": $scope.e_Name,
                            "ServiceType": $scope.e_ServiceType,
                            "District_OID": $scope.e_City,
                            "Currency_OID": $scope.e_Currency,

                            "MinCharge_Day": $scope.e_MinCharge_Day,
                            "MinCharge_Night": $scope.e_MinCharge_Night,

                            "StartCharge_Day": $scope.e_StartCharge_Day,
                            "StartCharge_Night": $scope.e_StartCharge_Night,

                            "DistanceCharge_Day": $scope.e_DistanceCharge_Day,
                            "DistanceCharge_Night": $scope.e_DistanceCharge_Night,

                            "WaitingCharge_Day": $scope.e_WaitingCharge_Day,
                            "WaitingCharge_Night": $scope.e_WaitingCharge_Night,

                            "Penalty_Distance": $scope.e_Penalty_Distance,
                            "User_Penelty": $scope.e_User_Penelty,
                            "Driver_Compensation": $scope.e_Driver_Compensation,

                            "Tax": $scope.e_Tax,
                            "Gov_Fees": $scope.e_Gov_Fees,
                            "App_Commission": $scope.e_App_Commission,
                            "ModifiedBy": sessionStorage.UserOID,
                            "TokenID": sessionStorage.TokenID
                        }
                        var obj = {};

                        obj["obj"] = tariff;
                        $.ajax({
                            type: "POST",
                            url: ManagementServiceUrl + "AddTarrif",
                            data: JSON.stringify(obj),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            processData: true,
                            success: function (data) {
                                if (data.UpdateDriverResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                var res = JSON.parse(data.AddTarrifResult);
                                // var str = "Hello world, welcome to the universe.";

                                //  console.log(res)
                                if (res = 'success') {
                                    $('#AddModal').modal('toggle');
                                    $scope.TariffList.get($scope.e_City)

                                } else {
                                    alert(res + "حدث خطأ  ")

                                }
                            }
                            });

                    },
                    edit: function (e) {
                        $scope.e_OID = e.OID;
                        $scope.e_Name = e.TariffName;
                        $scope.e_ServiceType = e.ServiceType;
                        $scope.e_City = e.District_OID;
                        $scope.e_Currency = e.Currency_OID;

                        $scope.e_MinCharge_Day = e.MinCharge_Day;
                        $scope.e_MinCharge_Night = e.MinCharge_Night;

                        $scope.e_StartCharge_Day = e.StartCharge_Day;
                        $scope.e_StartCharge_Night = e.StartCharge_Night;

                        $scope.e_DistanceCharge_Day = e.DistanceCharge_Day;
                        $scope.e_DistanceCharge_Night = e.DistanceCharge_Night;

                        $scope.e_WaitingCharge_Day = e.WaitingCharge_Day;
                        $scope.e_WaitingCharge_Night = e.WaitingCharge_Night;

                        $scope.e_Penalty_Distance = e.Penalty_Distance;
                        $scope.e_User_Penelty = e.User_Penelty;
                        $scope.e_Driver_Compensation = e.Driver_Compensation;

                        $scope.e_Tax = e.Tax;
                        $scope.e_Gov_Fees = e.Gov_Fees;
                        $scope.e_App_Commission = e.App_Commission;

                        $('#EditModal').modal('toggle');
                    },
                    saveEdits() {
                        if ($scope.e_Name == undefined || $scope.e_Name == "" ||
                            $scope.e_ServiceType == undefined || $scope.e_ServiceType == "" ||
                            $scope.e_City == undefined || $scope.e_City == "" ||
                            $scope.e_Currency == undefined || $scope.e_Currency == "" ||
                            $scope.e_MinCharge_Day == undefined || $scope.e_MinCharge_Day == null ||
                            $scope.e_MinCharge_Night == undefined || $scope.e_MinCharge_Night == null ||
                            $scope.e_DistanceCharge_Day == undefined || $scope.e_DistanceCharge_Day == null ||
                            $scope.e_DistanceCharge_Night == undefined || $scope.e_DistanceCharge_Night == null ||
                            $scope.e_WaitingCharge_Day == undefined || $scope.e_WaitingCharge_Day == null ||
                            $scope.e_WaitingCharge_Night == undefined || $scope.e_WaitingCharge_Night == null ||
                            $scope.e_StartCharge_Day == undefined || $scope.e_StartCharge_Day == null ||
                            $scope.e_StartCharge_Night == undefined || $scope.e_StartCharge_Night == null ||

                            $scope.e_Penalty_Distance == undefined || $scope.e_Penalty_Distance == null ||
                            $scope.e_Driver_Compensation == undefined || $scope.e_Driver_Compensation == null ||
                            $scope.e_User_Penelty == undefined || $scope.e_User_Penelty == null ||

                            $scope.e_Tax == undefined || $scope.e_Tax == null ||
                            $scope.e_Gov_Fees == undefined || $scope.e_Gov_Fees == null ||
                            $scope.e_App_Commission == undefined || $scope.e_App_Commission == null 
                            ) {
                            alert("يرجى ادخال جميع الحقول")
                            return;
                        } 
                        var tariff = {
                            "OID": $scope.e_OID,
                            "TariffName": $scope.e_Name,
                            "ServiceType" : $scope.e_ServiceType,
                            "District_OID": $scope.e_City,
                            "Currency_OID": $scope.e_Currency,

                            "MinCharge_Day": $scope.e_MinCharge_Day,
                            "MinCharge_Night": $scope.e_MinCharge_Night,

                            "StartCharge_Day": $scope.e_StartCharge_Day,
                            "StartCharge_Night" : $scope.e_StartCharge_Night,

                            "DistanceCharge_Day" : $scope.e_DistanceCharge_Day,
                            "DistanceCharge_Night" : $scope.e_DistanceCharge_Night,

                            "WaitingCharge_Day" : $scope.e_WaitingCharge_Day,
                            "WaitingCharge_Night": $scope.e_WaitingCharge_Night,

                            "Penalty_Distance" : $scope.e_Penalty_Distance,
                            "User_Penelty":$scope.e_User_Penelty,
                            "Driver_Compensation":$scope.e_Driver_Compensation,

                            "Tax":$scope.e_Tax,
                            "Gov_Fees":$scope.e_Gov_Fees,
                            "App_Commission": $scope.e_App_Commission,
                            "ModifiedBy": sessionStorage.UserOID,
                            "TokenID": sessionStorage.TokenID

                        }
                        var obj = {};

                        obj["obj"] = tariff;
                        $.ajax({
                            type: "POST",
                            url: ManagementServiceUrl + "UpdateTarrif",
                            data: JSON.stringify(obj),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            processData: true,
                            success: function (data) {
                                if (data.UpdateDriverResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                var res = JSON.parse(data.UpdateTarrifResult);
                                // var str = "Hello world, welcome to the universe.";

                                //  console.log(res)
                                if (res='success') {
                                    $('#EditModal').modal('toggle');
                                    $scope.TariffList.get($scope.e_City)

                                } else {
                                    alert(res + "حدث خطأ  ")

                                }




                            },
                        });


                    }

                }

                TariffList = $scope.TariffList;
                $scope.SelectCity = function (cityOid) {
                    $scope.TariffList.get(cityOid)
                }

            }
        }
    }]);



